# AttestLayer Offline Verification Kit

## Overview

This kit allows you to verify AttestLayer Registry entries offline,
without network access to the registry servers.

## Requirements

- Python 3.9 or later
- NO external dependencies

## Files

- `verify.py` - Standalone verification script
- `jwks/registry.jwks.json` - Registry public keys
- `jwks/issuer.jwks.json` - Issuer public keys
- `checkpoints/latest.json` - Latest checkpoint
- `README.md` - This file

## Usage

### Verify a single entry

```bash
python verify.py --entry entry.json
```

### Verify an NDJSON log file

```bash
python verify.py --log 2025-01-28.ndjson
```

### Verify chain integrity

```bash
python verify.py --chain 2025-01-28.ndjson
```

### Verify a checkpoint against a log

```bash
python verify.py --checkpoint checkpoint.json --log 2025-01-28.ndjson
```

## Verification Checks

The verifier performs these checks:

1. **Entry Hash Verification**: Confirms `entry_hash` is correctly computed
2. **Registry Signature**: Verifies `registry_sig` using registry JWKS
3. **Issuer Signature**: Verifies `issuer_attest.issuer_sig_b64` using issuer JWKS
4. **Chain Integrity**: Confirms `prev_entry_hash` links are unbroken
5. **Checkpoint Merkle Root**: Verifies Merkle root matches entries

## Specification

See https://registry.attestlayer.com/v1/spec/REG-1.0.md

## Support

For issues: https://github.com/attestlayer/registry/issues

---
Generated: 2026-03-01T07:06:43.195293+00:00
Registry ID: attestlayer-registry-prod
Spec: REG-1.0
